/*************************************************************************
 * The contents of this file are subject to the MYRICOM MX AND GM-2      *
 * MAPPING SOFTWARE AND DOCUMENTATION LICENSE (the "License"); User may  *
 * not use this file except in compliance with the License.  The full    *
 * text of the License can found in mapper directory in LICENSE.TXT      *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <string.h>
#ifdef WIN32
#define strdup _strdup
#endif
#include "lx.h"
#include "lx_tokens.h"

typedef struct lx_tokens_t
{
  FILE*fp;
  int max_line;
  char*whitespace;
  char*comments;
  char*line;
  char*s;
  int lines_read;
} lx_tokens_t;

void*lx_tokens_new (FILE*fp, int max_line, char*whitespace, char*comments)
{
  lx_tokens_t*t;
  
  insist (fp);
  insist (max_line > 80 && max_line < 1000);
  insist (whitespace);
  
  t = (lx_tokens_t*) calloc (1, sizeof (*t));
  insist (t);
  t->fp = fp;
  t->whitespace = strdup (whitespace);
  insist (t->whitespace);
  
  if (comments)
  {
    t->comments = strdup (comments);
    insist (t->comments);
  }
  t->line = (char*) malloc (max_line);
  insist (t->line);
  t->max_line = max_line;
  
  t->lines_read = -1;
  
  return (void*) t;
  except: return 0;
}

void lx_tokens_free (void*tokens)
{
  lx_tokens_t*t = (lx_tokens_t*) tokens;
  insist (t);

  if (t->whitespace) free (t->whitespace);
  if (t->comments) free (t->comments);
  if (t->line) free (t->line);
  free (t);
  except:;
}

char*lx_tokens_next (void*tokens)
{
  lx_tokens_t*t = (lx_tokens_t*) tokens;
  char*s;
  
  insist (t && t->fp);
  
  while (!t->s || (t->comments && strchr (t->comments, *t->s)))
  {
    if (!fgets (t->line, t->max_line, t->fp))
      return 0;
    t->lines_read++;
    t->s = strtok (t->line, t->whitespace);
  }
  
  s = t->s;
  t->s = strtok (0, t->whitespace);
  return s;
  
  except: return 0;
}

void lx_tokens_rewind (void*tokens)
{
  lx_tokens_t*t = (lx_tokens_t*) tokens;
  insist (t && t->fp);

  rewind (t->fp);
  t->s = 0;
  
  except:;
}

int lx_tokens_get_line (void*tokens)
{
  lx_tokens_t*t = (lx_tokens_t*) tokens;
  insist (t);
  return t->lines_read;
  
  except: return 0;
}

